/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.net;

import java.util.Locale;
import java.util.ResourceBundle;

public class GDKMessage {
    private static final String M_C_MESSAGEFILE = "oracle.i18n.net.Messages";
    private static final ResourceBundle bundle = ResourceBundle.getBundle("oracle.i18n.net.Messages", Locale.getDefault());
    private static final String GDK_PREFIX = "GDK";
    private static final String KEY_BASE = "00000";
    private static final int KEY_LENGTH = "00000".length();
    public static final int ISO_8859_1_NOT_SUPPORTED = 5200;
    public static final int FAILED_TO_CONVERT_TO_HEX = 5201;
    public static final int FAILED_TO_CONVERT_TO_DEC = 5202;
    public static final int UNREGISTERD_CHARACTER_ENTITY = 5203;
    public static final int INVALID_QP_VALUE = 5204;
    public static final int INVALID_MIME_HEADER_FORMAT = 5205;
    public static final int INVALID_NUMERIC_STRING = 5206;
    public static final int NO_CORRESPONDING_ORA_CHARSET = 5220;

    private GDKMessage() {
    }

    private static String msg(String string, Object object) {
        try {
            if (object != null) {
                return bundle.getString(string) + ": " + object;
            }
            return bundle.getString(string);
        }
        catch (Exception exception) {
            return "Message [" + string + "] not found in '" + M_C_MESSAGEFILE + "'.";
        }
    }

    public static String getMessage(String string, Object object) {
        return "GDK-" + string + ": " + GDKMessage.msg(string, object);
    }

    public static String getMessage(int n) {
        return GDKMessage.getMessage(n, null);
    }

    public static String getMessage(int n, Object object) {
        String string = new Integer(n).toString();
        if (string.length() < KEY_LENGTH) {
            string = KEY_BASE.substring(string.length()) + string;
        }
        return GDKMessage.getMessage(string, object);
    }
}

